/**
 * MachForm
 * 
 * © 2007–2025 Appnitro Software. All rights reserved.
 * 
 * This source code is proprietary and may not be copied, modified,
 * or distributed in any form without express written permission from Appnitro Software.
 * 
 * License information: https://www.machform.com/license-agreement/
 */

//code for overloading the :contains selector to be case insensitive
jQuery.expr.pseudos.Contains = function(a, i, m) {
	return jQuery(a).text().toUpperCase()
		.indexOf(m[3].toUpperCase()) >= 0;
};
jQuery.expr.pseudos.contains = function(a, i, m) {
	return jQuery(a).text().toUpperCase()
		.indexOf(m[3].toUpperCase()) >= 0;
};

/*** Functions ***/

//highlight one item of the permission list based on the form_id
function highlight_permission_list(form_id){

	//remove any highlight
	$("#li_" + form_id).removeClass('highlight_red highlight_green highlight_yellow');

	//decide which highlight need to be applied for this item
	if($("#perm_editform_"+ form_id).prop("checked") == true){
		$("#li_" + form_id).addClass("highlight_red");
	}else if($("#perm_editentries_"+ form_id).prop("checked") == true){
		$("#li_" + form_id).addClass("highlight_yellow");
	}else if($("#perm_viewentries_"+ form_id).prop("checked") == true || $("#perm_editreport_"+ form_id).prop("checked") == true){
		$("#li_" + form_id).addClass("highlight_green");
	}

}

//highlight the whole permission list, based on selected checkboxes on each list
function highlight_refresh_all(){
	$("#au_li_permissions > li").each(function(){
		var temp = $(this).attr("id").split("_");
		var form_id = temp[1];

		//remove any highlight
		$("#li_" + form_id).removeClass('highlight_red highlight_green highlight_yellow');

		//decide which highlight need to be applied for this item
		if($("#perm_editform_"+ form_id).prop("checked") == true){
			$("#li_" + form_id).addClass("highlight_red");
		}else if($("#perm_editentries_"+ form_id).prop("checked") == true){
			$("#li_" + form_id).addClass("highlight_yellow");
		}else if($("#perm_viewentries_"+ form_id).prop("checked") == true || $("#perm_editreport_"+ form_id).prop("checked") == true){
			$("#li_" + form_id).addClass("highlight_green");
		}
	});
}

//clear the form filter
function reset_form_filter(){
	$("#au_li_permissions > li").show();
	$("#au_li_permissions .au_perm_title").unhighlight();

	$("#search_result_box").hide();
	$("#au_bulk_select").show();
}

$(function(){
    
	/***************************************************************************************************************/	
	/* 1. Load Tooltips															   				   				   */
	/***************************************************************************************************************/
	
	//we're using tippy for the tooltip
	tippy('[data-tippy-content]',{
		trigger: 'click',
		placement: 'bottom',
		boundary: 'window',
		arrow: true
	});
	
	/***************************************************************************************************************/	
	/* 2. Attach event to Permissions Checkboxes								   				   				   */
	/***************************************************************************************************************/

	//attach event to 'edit form','view entries' and 'edit report' checkbox
	$("#au_li_permissions .cb_editform,#au_li_permissions .cb_viewentries,#au_li_permissions .cb_editreport").on('change', function() {
		var temp = $(this).attr("id").split('_');
		highlight_permission_list(temp[2]);
	});

	//attach event to 'edit entries' checkbox
	$("#au_li_permissions .cb_editentries").on('change', function() {
		var temp = $(this).attr("id").split('_');
		var form_id = temp[2];

		if($(this).prop("checked") === true){
			$("#perm_viewentries_" + form_id).prop("checked",true);
			$("#perm_viewentries_" + form_id).prop("disabled",true);
		}else{
			$("#perm_viewentries_" + form_id).prop("disabled",false);
		}

		highlight_permission_list(form_id);
	});

	/***************************************************************************************************************/	
	/* 3. Attach event to 'Add User' button																	   	   */
	/***************************************************************************************************************/
	
	$("#button_add_user").on('click',function(){
		
		if($("#button_add_user").text() != 'Adding User...'){
				
				//display loader while saving
				$("#button_add_user").prop("disabled",true);
				$("#button_add_user").text('Adding User...');
				$("#add_user_form").trigger("submit");
		}
		
		return false;
	});

	/***************************************************************************************************************/	
	/* 4. Attach event to 'Save Changes' button on edit user page											   	   */
	/***************************************************************************************************************/
	
	$("#button_edit_user").on('click',function(){
		
		if($("#button_edit_user").text() != 'Saving...'){
				
				//display loader while saving
				$("#button_edit_user").prop("disabled",true);
				$("#button_edit_user").text('Saving...');
				$("#add_user_form").trigger("submit");
		}
		
		return false;
	});

	/***************************************************************************************************************/	
	/* 5. Attach event to 'Bulk Action' drop down															   	   */
	/***************************************************************************************************************/
	$('#au_bulk_action').on('change', function() {
		var bulk_action = $(this).val();

		if(bulk_action == 'select_editform'){
			$("#au_li_permissions .cb_editform").prop("checked",true);
			$("#au_li_permissions > li").removeClass('highlight_red highlight_green highlight_yellow').addClass('highlight_red');
		}else if(bulk_action == 'select_editentries'){
			$("#au_li_permissions .cb_editentries").prop("checked",true);
			$("#au_li_permissions .cb_viewentries").prop("disabled",false).prop("checked",true).prop("disabled",true);

			highlight_refresh_all();
		}else if(bulk_action == 'select_viewentries'){
			$("#au_li_permissions .cb_viewentries").prop("checked",true);

			highlight_refresh_all();
		}else if(bulk_action == 'select_editreport'){
			$("#au_li_permissions .cb_editreport").prop("checked",true);

			highlight_refresh_all();
		}else if(bulk_action == 'unselect_editform'){
			$("#au_li_permissions .cb_editform").prop("checked",false);

			highlight_refresh_all();
		}else if(bulk_action == 'unselect_editentries'){
			$("#au_li_permissions .cb_editentries").prop("checked",false);
			$("#au_li_permissions .cb_viewentries").prop("disabled",false);

			highlight_refresh_all();
		}else if(bulk_action == 'unselect_viewentries'){
			$("#au_li_permissions .cb_viewentries").not(':disabled').prop("checked",false);

			highlight_refresh_all();
		}else if(bulk_action == 'unselect_editreport'){
			$("#au_li_permissions .cb_editreport").prop("checked",false);

			highlight_refresh_all();
		}
	});

	/***************************************************************************************************************/	
	/* 6. Attach event to Administer Checkbox								   				   				   */
	/***************************************************************************************************************/

	$("#au_priv_administer").on('change', function() {
		if($(this).prop("checked") == true){
			$("#au_priv_new_forms,#au_priv_new_themes").prop("checked",true);
			$("#au_priv_new_forms,#au_priv_new_themes").prop("disabled",true);
			$(".user_permissions_list").fadeOut();
			
		}else{
			$("#au_priv_new_forms,#au_priv_new_themes").prop("disabled",false);
			$(".user_permissions_list").fadeIn();
			
		}	
	});
	
	//filter the form when user type the search term
	$("#search_form_name").on("keyup",function(){
		var search_term = $(this).val();

		if(search_term != ''){
			//first hide all form
			$("#au_li_permissions > li").removeClass('result_set').hide();
		
			var result_list = $("#au_li_permissions .au_perm_title:contains('"+ search_term + "')");
			
			result_list.parent().show().addClass('result_set');
			result_list.unhighlight();
			result_list.highlight(search_term);

			$("#search_result_box span.highlight").text(search_term);
			$("#search_result_total").text(result_list.length);
			$("#search_result_box").fadeIn();
			
			$("#au_bulk_select").hide();
		}else{
			//if the filter keyword is empty, restore back to the original condition
			reset_form_filter();
		}
	});

	$("#mf_search_reset").on('click',function(){
		reset_form_filter();

		$("#search_form_name").val('');
		
		return false;
	});
	
});